#include <stdio.h>
#include <memory.h>
#include <math.h>
#include <sys/time.h>
#include <malloc.h>

#include "tab.h"
#include "stack.h"


extern int level;            /* current depth of search tree */
extern int max_level;        /* Max level in current tree */
extern int max_var;          /* largest var seen in theory */
extern char horn_flg;        /* Use horn clause heuristic when true */

extern struct var *var_array;          /* array of information about vars */
extern char *val;                      /* current variable values */
extern int *vars_valued;

extern struct stack *nogood;
extern struct stack **why;

#ifdef BINARY_COUNT
/* Binary counts.  These are kept as negative numbers (e.g. -2 means 2 occurances).
   Also, the counts are only valid for unvalued variables. */
extern char *pbin;                     /* current binary counts */
extern char *nbin;                     /* current binary counts */
#endif

#define MAX_TO_KEEP 10
int top_10[MAX_TO_KEEP];
int top_10_score1[MAX_TO_KEEP];
int top_10_score2[MAX_TO_KEEP];
int lks1,lks2;             /* lks1,lks2 is at or below lowest kept score in the array */
int bks1;                  /* highest kept score on metric 1 */
int to_keep;

#define MAX_UNLUCKY_LITS 10
int unlucky[MAX_UNLUCKY_LITS];
int unlucky_score[MAX_UNLUCKY_LITS];
int lus;                   /* lower bound on scores in unlucky_score */
int unlucky_lits;

struct stack *pop_nogood();


metric1(i)
int i;
{
  int pc = get_bin(i);
  int nc = get_bin(-i);

  /* save unlucky lits as candidates for failed lits */
  if (unlucky_lits>0) {
    if (pc > lus) unlucky_lit(i,pc);
    if (nc > lus) unlucky_lit(-i,nc);
  }

  return(pc*nc*1024 + pc + nc + 1);
}

metric2(i)
int i;
{
  int ai = abs(i);
  int pc = stack_length(var_array[ai].pos_clauses) + stack_length(var_array[ai].neg_hits);
  int nc = stack_length(var_array[ai].neg_clauses) + stack_length(var_array[ai].pos_hits);

  return(pc*nc*1024 + pc + nc + 1);
}


/* 
Return values:
   1 = normal return.  *var has been set to branch var.
   0 = all variables are valued.
  -1 = cbl has found that current partial assignment is inconsistent
*/

random_cbl(p)
int *p;
{
  int i;
  for(i=1;;i++) {
    if (i > max_var) return(0);   /* model found */
    if (val[i]==0) break;         /* no model yet */
  }
  for( i=my_rand(max_var); val[i] != 0; i=my_rand(max_var));
  *p=i;
  return(1);
}

cbl(p)
int *p;
{
  int i;
  int score1, score2;
  int var, best_var, best_score=0;

  to_keep = min(MAX_TO_KEEP,max_var/40);
  if (to_keep < 1) to_keep = 1;
  unlucky_lits=10;

  lks1 = 0; lks2 = 0; bks1 = 0;
  for(i=0;i<to_keep;i++) {top_10_score1[i]=0; top_10_score2[i]=0;}
  lus = 0;
  for(i=0;i<unlucky_lits;i++) unlucky_score[i]=0;

  /* First we find the best to_keep variables: */
  for(i=1;i<=max_var;i++) {
    if (val[i]==0) {  /* if i unvalued */
      if (horn_flg && !occurs_non_horn(i)) {
#ifdef TRACE
        printf("%d occurs only in horn clauses\n",i);
#endif
        continue;
      }
      if ((score1 = metric1(i)) > lks1) {
	keep_var(i,score1,metric2(i));}
      else if ((score1 == lks1) && ((score2 = metric2(i)) > lks2)) {
	keep_var(i,score1,score2);}
    }
  }

  /* if bks1 is still 0 then there are no unvalued vars */
  if (bks1 == 0) return(0);

  /* check unlucky lits to see if any fail */
  for(i=0;i<unlucky_lits;i++) {
    int lit = unlucky[i];
    if (!(lit == 0) && (val[abs(lit)] == 0)) {
      if (! assume(lit)) {
	end_level();
	stack_delete(nogood,lit);
	copy_stack_data(why[abs(lit)],nogood);
	if (! value(-lit)) return(CONTRADICTION);
	continue;}
      end_level();
    }
  }

  /* Then we use a more expensive metric to choose one of the kept vars. */
  if (to_keep == 1) {
    *p = top_10[0];
    if (val[*p] == 0) {return(1);} else return(cbl(p));
  }

  for(i=0;i<to_keep;i++) {
    int pc, nc;
    var = top_10[i];
    if ((var > 0) && (val[var] == 0)) {
      if (! (pc = assume(var))) {
	end_level();
	stack_delete(nogood,var);
	copy_stack_data(why[abs(var)],nogood);
	if (!value(-var)) return(CONTRADICTION);
	continue;
      }
      end_level();
  
      if (! (nc = assume(-var))) {
	end_level();
	stack_delete(nogood,-var);
	copy_stack_data(why[abs(var)],nogood);
	if (!value(var)) return(CONTRADICTION);
	continue;
      }
      end_level();

      if (pc*nc*1024 + pc + nc + 1 > best_score) {
	best_score = pc*nc*1024 + pc + nc + 1;
	best_var = var;
	/* need to come back and try this both ways on larger problem set */
	/* if (pc<nc) {best_var = var;} else best_var = -var; */
      }
    }
  }

  /* If best_score is zero this means all vars in top_10 received values.
     In this case just call cbl again.
     best_var may have received a value by some subsequent UR.
     In this case we also call cbl again.
     */
  if ((best_score == 0) || (val[best_var]!=0)) return(cbl(p));
  *p = best_var;
  return(1);
}



keep_var(i,s1,s2)
int i,s1,s2;
{
  int j;

  for(j=0;j<to_keep;j++) {
    if ((s1 > top_10_score1[j]) ||
	((s1 == top_10_score1[j]) && (s2 > top_10_score2[j]))) {
      top_10[j] = i;
      top_10_score1[j] = s1;  if (s1 > bks1) bks1 = s1;
      top_10_score2[j] = s2;
      return(1);
    }
  }
  
  /* If we get this far then s1,s2 is less than or equal to all scores in array */
  lks1 = s1; lks2 = s2;
}


unlucky_lit(i,s)
int i,s;
{
  int j;

  for(j=0;j<unlucky_lits;j++) {
    if (s > unlucky_score[j]) {
      unlucky[j] = i;
      unlucky_score[j] = s;
      return(1);
    }
  }
  
  /* If we get this far then s is less than or equal to all scores in array */
  lus = s;
}

/* Returns t iff i or -i appears in a horn clause */
occurs_non_horn(i)
  int i;
{
  struct var *is=&var_array[i];

  /* First check the binary clauses.  Here we just have to
     check whether i has a neg_hit that is positive and unvalued. */
  map_stack(is->neg_hits,
	    if ((*ptr>0) && val[*ptr]==0) {
	      return(1);
	    });

  map_stack(is->pos_clauses,
	    struct clause* c = ((struct clause*) *ptr);
	    if (!redundant(c->text) &&  (c->pos_terms>1)) {
	      return(1);
	    });

  return(0);
}
