
/* INPUT: Copyright 1996 James Crawford, CIRL, The University of Oregon.
   Distributed for research purposes only.  No warantee.
 */

#include <stdio.h>
#include <ctype.h>

#include "tab.h"
#include "stack.h"

extern int mvar;
extern struct stack *all_clauses;
/*extern struct stack *clean_clauses; USED ONLY BY COMPACT */
extern struct stack *nh_clauses;
extern struct stack *input_lits;
extern int max_var;
extern struct var *var_array;
extern char *val;
#ifdef BINARY_COUNT
extern char *pbin, *nbin;
#endif

struct stack *clause_get();
struct stack *cleanup_clause();
struct stack *copy_stack();


input_wff()
{
  struct stack *text;

  while(1) {
    if (clause_get(&text,stdin) == NULL) break; /* end of input */
    if (! empty_stack(text)) assert_clause(text);
  }

#ifdef DEBUG
  printf("Input literals: ");
  print_stack(input_lits);
  printf("\n");
  printf("Input clauses: ");
  map_stack(all_clauses,print_stack(*ptr));
  printf("\n");
#endif
}

assert_clause(text)
struct stack *text;
{
  struct clause *clause;
  int len,pos_len;
  int i;

  spush(copy_stack(text),all_clauses);

  if (cleanup_clause(text) == NULL) return(1); /* Clause cleaned up into tautology */
/*  spush(copy_stack(text),clean_clauses);*/
  len=stack_length(text);
    
  if (len==1) {
    if (!try_assign(ftop(text))) {
#ifdef ARI_COMPILER
      printf("-1 UNSAT\n");
#else
      printf("UNSAT\nContradiction after unit resolution.\n");
#endif
      exit(0);
    }
    return(1);
  }

  if (len==2) {
    int first = ftop(text), second = fsecond(text);
    struct var *fs=&var_array[abs(first)], *ss=&var_array[abs(second)];

    if (first>0) {spush(second,fs->neg_hits);}
    else spush(second,fs->pos_hits);

    if (second>0) {spush(first,ss->neg_hits);}
    else spush(first,ss->pos_hits);

#ifdef BINARY_COUNT
    incf_bin(first); incf_bin(second);
#endif
  }
  /* Don't need clause struct for binary horn clauses: */
  if ((len==2) && (pos_len < 2)) return(1);

  clause = ((struct clause *) malloc(sizeof(struct clause)));
  clause->text = text;
  clause->terms = len;
  pos_len = 0; map_stack(text,if((*ptr)>0)pos_len++);
  clause->pos_terms=pos_len;
  clause->irred=1;

  if(clause->pos_terms>1) spush(clause,nh_clauses);
#ifdef DEBUG
  print_clause(clause);
#endif

  /* index clauses of length 3 or more */
  if(len==2) return(1);
  map_stack(text,
	    {if (*ptr > 0) {spush(clause,var_array[abs(*ptr)].pos_clauses);}
	    else {spush(clause,var_array[abs(*ptr)].neg_clauses);}});
}

/* Try_Assign is like value, but no unit resolution is done --
instead x is pushed onto a stack to be unit resolved latter.
*/
try_assign(x)
int x;
{
#ifdef DEBUG
  printf("Setting %d.\n",x);
#endif
  if (val[abs(x)]==0) {
    val[abs(x)]=sign(x);
    spush(x,input_lits);
  }
  else return(val[abs(x)]==sign(x));
}


/* Returns NULL if clause cleans up into tautology. */
struct stack *cleanup_clause(text)
struct stack *text;
{
  int opposite_val();

  /* Delete the clause if it is subsumed by a literal or if it contains x and -x */
  map_stack(text,
	    {if (val[abs(*ptr)] == sign(*ptr)) return(NULL);
	     if (stack_find(text,-(*ptr))) return(NULL);});

  stack_delete_if(text,opposite_val);

  if (empty_stack(text)) {
#ifdef ARI_COMPILER
      printf("-1 UNSAT\n");
#else
      printf("UNSAT\nContradiction after unit resolution.\n");
#endif
    exit(0);
  }

  stack_remove_duplicates(text);
  return(text);
}

opposite_val(x)
int x;
{
  return(val[abs(x)] == -sign(x));
}


/* Reads a single line of input as a stack.
   Returns NULL on EOF or %. */
struct stack *clause_get(s,iop)
struct stack **s;
register FILE *iop;
{
  int x,r;

  *s = new_stack(3);
  while((r = read_int(iop,&x)) != EOF) {
    if (x == 0) break;
    if (abs(x)>=mvar) {
      fprintf(stderr,"Variable %d exceeds maximum %d.\n",x,mvar);
      exit(1);
    }
    if (abs(x)>max_var) max_var=abs(x);
    spush(x,*s);
  }
  return((r == EOF && (empty_stack(*s))) ? NULL : *s);
}


/* Returns EOF on % or EOF.  Else sets x to zero on end of line, or to next integer */
read_int(iop,x)
register FILE *iop;
int *x;
{
  register int c;

  while (! numberp(c = getc(iop))) {
    if (c == '%') return(EOF);
    if (c == EOF) return(EOF);
    if (c == '\n') {*x=0; return(0);}
  }
  ungetc(c,iop);
  fscanf(iop,"%d",x);
  return(0);
}

numberp(x)
int x;
{
  return(isdigit(x) || (x == '-'));
}


print_clause(c)
struct clause *c;
{
  print_stack(c->text);
  printf(" terms: %d pos-terms: %d\n",c->terms,c->pos_terms);
}

print_var(var,st)
int var;
struct var *st;
{
  printf("\n\n%d pos_hits: ",var);
  print_stack(st->pos_hits);
  printf("\n  neg_hits: ");
  print_stack(st->neg_hits);
  printf("\n  pos_clauses:\n");
  map_stack(st->pos_clauses,print_clause(*ptr));
  printf("\n  neg_clauses:\n");
  map_stack(st->neg_clauses,print_clause(*ptr));
  printf("\n");
}
