#include <stdio.h>
#include <ctype.h>

#include "tab.h"
#include "stack.h"

/* TODO: Add ur_light -- value propagation (and bins_created count) only. */

extern int level;
extern struct stack *ur_stack;
extern struct var *var_array;
extern char *val;
#ifdef BINARY_COUNT
extern char *pbin, *nbin;
#endif
extern struct stack *undo;
#ifdef OTHER_COUNTS
extern int *vars_valued, bins_created;
#endif



value(x)
int x;
{
  int var,s;

  if (x>0) {s=1;var=x;} else {s=-1;var=-x;}

#ifdef TRACE
  printf("%d ",x);
#endif
  if (val[var]==0) {
#ifdef OTHER_COUNTS
    (*vars_valued)++;
#endif
    val[var]=s;
    return(ur(x));
  }
  else return(val[var]==s);
}


/*
This is like value but pushes onto the stack instead of
recursively calling ur.
*/
internal_value(x)
int x;
{
  int var,s;

  if (x>0) {s=1;var=x;} else {s=-1;var=-x;}

#ifdef TRACE
  printf("%d ",x);
#endif
  if (val[var]==0) {
#ifdef OTHER_COUNTS
    (*vars_valued)++;
#endif
    val[var]=s;
    fpush(x,ur_stack);
    return(1);
  }
  else return(val[var]==s);
}



#define decf_count(p) {spush(((int) &(p)),undo); (p)--;}

ur(x)
int x;
{
  int *ur_stack_ptr; /* points to the next lit to be ur'ed */

  ur_stack_ptr = make_empty(ur_stack); /* ur_stack_ptr set to bottom of stack */
  fpush(x,ur_stack);
#ifdef DEBUG
  print_stack(ur_stack);
#endif

  while(! (ur_stack_ptr == ur_stack->fill_ptr)) {
    int x = *ur_stack_ptr++;
    register int *ptr;
    struct var xs;
    struct stack *hits,*clauses;
#ifdef BINARY_COUNT
    struct stack *red_vars, *red_clauses;
#endif
    int *top;
    struct clause *c;

    if (x<0) {
      xs = var_array[-x];
      hits = xs.neg_hits; clauses = xs.pos_clauses;
#ifdef BINARY_COUNT
      red_vars = xs.pos_hits; red_clauses = xs.neg_clauses;
#endif
    }
    else {
      xs = var_array[x];
      hits = xs.pos_hits; clauses = xs.neg_clauses;
#ifdef BINARY_COUNT
      red_vars = xs.neg_hits; red_clauses = xs.pos_clauses;
#endif
    }
#ifdef DEBUG
    printf(" ur:%d ",x);
#endif

    top = hits->fill_ptr; /* cash this out since it does not change */
    for(ptr=hits->bottom; ptr < top; ptr++)  /* map over the stack hits */
      if (!internal_value(*ptr)) return(0);

#ifdef BINARY_COUNT
    top = red_vars->fill_ptr; /* cash this out since it does not change */
    for(ptr=red_vars->bottom; ptr < top; ptr++)  /* map over the stack red_vars */
      decf_bin(*ptr);
#endif
      
    top = clauses->fill_ptr;
    for(ptr=clauses->bottom; ptr < top; ptr++) {
      c = ((struct clause *) *ptr);
      if (x<0) decf_count(c->pos_terms);
      decf_count(c->terms);
      if (c->terms == 1) if (!walk_clause(c->text)) return(0);
#ifdef BINARY_COUNT
      if (c->terms == 2) {
#ifdef OTHER_COUNTS
	bins_created++;
#endif
	map_stack(c->text,incf_bin(*ptr));
      }
#endif
    }

#ifdef BINARY_COUNT
    top = red_clauses->fill_ptr; /* cash this out since it does not change */
    for(ptr=red_clauses->bottom; ptr < top; ptr++)  { /* map over the stack red_clauses */
      c = ((struct clause *) *ptr);
      if (c->terms == 2) {
	struct cons *lp;
	map_stack(c->text,decf_bin(*ptr));
      }
    }
#endif
  }

  return(1);
}


walk_clause(s)
struct stack *s;
{
  map_stack(s,if(val[abs(*ptr)]==0) return(internal_value(*ptr)));

  /* at this point every term in clause has a value */
  map_stack(s,if(val[abs(*ptr)] == sign(*ptr)) return(1));

#ifdef TRACE
  printf("No unvalued lits in clause: ");
  print_stack(s);
  printf("\n");
#endif
  return(0);
}


occurs(i)
int i;
{
  if (i > 0) {return(occurs_pos(i));}
  else return(occurs_neg(-i));
}


occurs_pos(i)   /* returns 1 iff i occurs positively in an irredundant clause */
int i;
{
  struct var *is = &var_array[i];
  register int *ptr;
  int *top;
  struct clause *c;

#ifdef TRACE
  printf("Occurs check on %d.  ",i);
#endif
    
  top = (is->neg_hits)->fill_ptr;
  for(ptr=(is->neg_hits)->bottom; ptr<top; ptr++)
    if (val[abs(*ptr)] == 0) {
#ifdef TRACE
      printf("%d occurs in binary clause with %d.\n",i,*ptr);
#endif
      return(1);
    }
    
  top = (is->pos_clauses)->fill_ptr;
  for(ptr=(is->pos_clauses)->bottom; ptr<top; ptr++) {
    c = ((struct clause *) *ptr);
    if (! redundant(c->text)) {
#ifdef TRACE
      printf("%d occurs in clause ",i);
      print_stack(c->text);
      printf("\n");
#endif
      return(1);
    }
  }
    
#ifdef TRACE
  printf("%d does not occur.\n",i);
#endif
  return(0);
}

occurs_neg(i)   /* returns 1 iff i occurs negatively in an irredundant clause */
int i;
{
  struct var *is = &var_array[i];
  register int *ptr;
  int *top;
  struct clause *c;

#ifdef TRACE
  printf("Occurs check on %d.",-i);
#endif
  
  top = (is->pos_hits)->fill_ptr;
  for(ptr=(is->pos_hits)->bottom; ptr<top; ptr++)
    if (val[abs(*ptr)] == 0)  {
#ifdef TRACE
      printf("%d occurs in binary clause with %d.\n",-i,*ptr);
#endif
      return(1);
    }
    
  top = (is->neg_clauses)->fill_ptr;
  for(ptr=(is->neg_clauses)->bottom; ptr<top; ptr++) {
    c = ((struct clause *) *ptr);
    if (! redundant(c->text)) {
#ifdef TRACE
      printf("%d occurs in clause ",-i);
      print_stack(c->text);
      printf("\n");
#endif
      return(1);
    }
  }
    
#ifdef TRACE
  printf("%d does not occur.\n",-i);
#endif
  return(0);
}


redundant(s)
struct stack *s;
{
  map_stack(s,if(val[abs(*ptr)]==sign(*ptr)) return(1));
  return(0);
}
